/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.GameControl;
import control.MenuControl;
import data.ColorArrangement;
import data.Constants;
import view.EndView;
import view.KeyboardInput;

public class EndControl {
    private static int[] scoreIncrement = new int[]{50, 100, 200, 500, 1000, 10000};
    private static int[] timeIncrement = new int[]{1, 5, 10, 30, 60, 90, 120, 180, 300, 600};
    private static boolean scoreEntered = false;
    private EndView view;
    public static boolean move = false;

    public EndControl(ColorArrangement colorArrangement, GameControl gameControl) {
        int i;
        KeyboardInput.clearBuffer();
        this.view = new EndView(colorArrangement, gameControl.getSoundController());
        this.view.yScale = (float)(Constants.VIEW_HEIGHT / 2) / (float)ColorArrangement.largestScore;
        float f = this.view.yScale = this.view.yScale < 1.0f ? this.view.yScale : 1.0f;
        if (ColorArrangement.largestScore <= Constants.VIEW_HEIGHT / 2) {
            i = 0;
            while (i < scoreIncrement.length) {
                if (Constants.VIEW_HEIGHT / 2 / scoreIncrement[i] <= 10) {
                    this.view.thisScoreIncrement = scoreIncrement[i];
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < scoreIncrement.length) {
                if (ColorArrangement.largestScore / scoreIncrement[i] <= 10) {
                    this.view.thisScoreIncrement = scoreIncrement[i];
                    break;
                }
                ++i;
            }
        }
        this.view.thisTimeIncrement = 0;
        i = 0;
        while (i < timeIncrement.length) {
            if (gameControl.getSoundController().getSongLength() / 1000 / timeIncrement[i] <= 10) {
                this.view.thisTimeIncrement = timeIncrement[i];
                break;
            }
            ++i;
        }
        if (this.view.thisTimeIncrement == 0) {
            int tempTime = timeIncrement[timeIncrement.length - 1];
            while (gameControl.getSoundController().getSongLength() / 1000 / tempTime > 10) {
                tempTime *= 2;
            }
            this.view.thisTimeIncrement = tempTime;
        }
        this.view.timeSpace = (float)Constants.VIEW_WIDTH / ((float)gameControl.getSoundController().getSongLength() / 1000.0f / (float)this.view.thisTimeIncrement);
        gameControl.killSoundController();
    }

    public static void updateScoreEntered(boolean in) {
        scoreEntered = in;
    }

    public static boolean isScoreEntered() {
        return scoreEntered;
    }

    public boolean update() {
        this.view.draw(MenuControl.offsetX, MenuControl.offsetY);
        return this.view.update(MenuControl.offsetX, MenuControl.offsetY);
    }
}

